import { Request, Response } from 'express';
import { notificationsService } from './service';

function hasFeature(user: any, featureKey: string): boolean {
  return user?.features?.includes(featureKey);
}

export const notificationsController = {
  // GET /notifications
  async list(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });
    // Feature gate for push is optional, but all users can get in-app
    const { status, type, date_range } = req.query;
    const filters: any = { status, type, date_range };
    const { data, error } = await notificationsService.listNotifications(user.id, filters);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // PATCH /notifications/:id/read
  async markAsRead(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });
    const { id } = req.params;
    const { data, error } = await notificationsService.markAsRead(user.id, id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // DELETE /notifications/:id
  async delete(req: any, res: Response) {
    const user = req.user;
    if (!user) return res.status(401).json({ error: 'Unauthorized' });
    const { id } = req.params;
    const { data, error } = await notificationsService.deleteNotification(user.id, id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // POST /notifications/send
  async send(req: any, res: Response) {
    // Only admin or system service should call this in production
    // For now, allow any authenticated user for demo
    const { data, error } = await notificationsService.sendNotification(req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.status(201).json({ success: true, data });
  }
}; 